//
//  MedicalPackage.h
//  as350b3e
//
//  Created by Vadim Dagman on 4/3/14.
//
//

#import <Foundation/Foundation.h>

@interface MedicalItem : NSObject

@property NSString* station;
@property (nonatomic) float weight;
@property bool selected;
@property (nonatomic) float arm;
@property (nonatomic) float moment;
@property (nonatomic) float armLat;
@property (nonatomic) float momentLat;
@property bool weightInKg;

- (id)initWithDictionary:(NSDictionary*)dict;
- (NSDictionary*)convertToDictionary;
- (NSString*)convertToString;

@end

@interface MedicalPackage : NSObject

@property NSString* packageName;
@property NSString* longitudinal;
@property NSString* lateral;
@property NSArray* items;
@property (nonatomic) float totalWeight;
@property (nonatomic) float totalArm;
@property (nonatomic) float totalMoment;
@property (nonatomic) float totalArmLat;
@property (nonatomic) float totalMomentLat;
@property (nonatomic) bool weightInKg;
@property NSString* serializeKey;
@property (nonatomic) bool selected;

- (id)initWithSerializeKey:(NSString*)serializeKey;
- (NSDictionary*)convertToDictionary;
- (NSString*)convertToString;
- (void)deleteItem:(MedicalItem*)item;
- (void)addItem:(MedicalItem*)item;
- (void)serialize;
- (void)wipeOut;
+ (MedicalPackage*)emptyPackage;


@end
